/**
 Démo Sécurisation d'une application N Tiers
 * Couche métier EJB
 * Lécu Régis, 12/10/2016
 */
package javaeetutorial.cartsecure.ejb;

import java.util.List;
import javaeetutorial.cartsecure.util.BookException;
import javax.ejb.Remote;

@Remote
public interface Cart {
    // création du panier, avec un nom de client
    public void initialize(String person) throws BookException;

    // création de panier, avec un nom et un id de client
    public void initialize(
        String person,
        String id) throws BookException;

    // ajout d'un livre au panier (avec son titre)
    public void addBook(String title);

    // suppression d'un livre (par son titre)
    public void removeBook(String title) throws BookException;

    // liste des livres
    public List<String> getContents();

    // vide le panier
    public void remove();
}
